/*
  Antenna Rotator Position Indicator
  Yaesu version

  Glen Popiel - KW5GP

  Uses the Adafruit NeoPixel library
  
  Released under the GPLv3 license
*/

//#define debug // Uncomment this to enable the display of debug information on the Serial Monitor

#include <Adafruit_NeoPixel.h>

#define led_pin 6 // Define the Neopixel I/O pin

#define rotator_pot A0 // Define the rotator position input

#define cal_zero 6  // define the zero calibration point

#define cal_max 245 // define the max calibration point

#define num_pixels 12 // NeoPixel Ring size

#define overlap 4 // For Yaesu we need to define number of overlap rotation pixels for 450 degrees

// Setup the NeoPixel library
// Uncomment the following for standard RGB Neopixel/WS281x LED Strips
//Adafruit_NeoPixel pixels(num_pixels, led_pin, NEO_GRB + NEO_KHZ800);

// Uncomment the following for RGBW Neopixel/WS281x LED Strips (RGB w/White LED)
// If you look at the unlit LEDs, half of each LED is covered with yellow
Adafruit_NeoPixel pixels(num_pixels, led_pin, NEO_GRBW + NEO_KHZ800);

#define delay_time 500 // Time (in milliseconds) to pause between pixels

int rotator_input = 0, current_pixel = 0, last_pixel = 0; // sketch variables

void setup()
{
#ifdef debug
  Serial.begin(9600); // Start the serial port if debugging is enabled
#endif

  pixels.begin(); // Initialize the NeoPixel display
  pixels.clear(); // Set all pixel colors to 'off'
  pixels.show();   // Send the updated pixel colors to the hardware
}

void loop()
{
  rotator_input = analogRead(rotator_pot);  // Read the Rotator Position Indictor

#ifdef debug
  Serial.print("Rotator Input = ");
  Serial.print(rotator_input);
#endif

  current_pixel = map(rotator_input, cal_zero, cal_max, 0, (num_pixels + overlap) - 1);  // Map the current rotator position to the appropriate pixel

  if (current_pixel > num_pixels - 1) // Check to see if the rotator has gone beyond 360 degrees (overlap)
  {
    // We're in overlap - subtract a full rotation 

#ifdef debug
  Serial.print("   Overlap Condition = ");
  Serial.print(current_pixel);
#endif
    
    current_pixel = (current_pixel - num_pixels); // Subtract a full rotation to get the relative value of the pixel to light
  }

#ifdef debug
  Serial.print("   Mapped to = ");
  Serial.println(current_pixel);
#endif

  pixels.setPixelColor(last_pixel, pixels.Color(0, 0, 0));  // Turn off the previous pixel

  pixels.setPixelColor(current_pixel, pixels.Color(0, 150, 0));  // display the corresponding LED pixel
  pixels.show();
  
  if (last_pixel != current_pixel)  // Only update the LED ring if the LED to light has changed
  {
    last_pixel = current_pixel;
  }
  delay(delay_time);
}



